implementation module intrface

from ostypes   import Rect
from ostoolbox import OSToolbox
from osrgn     import OSRgnHandle


::	CSTR	:==  Int
::	ACCLPTR	:==  Int
::	HDC		:==  Int
::	HWND	:==  Int
::	HITEM	:==  Int
::	HMENU	:==  Int
::	HRGN	:==  Int	// PA: new type def
::	Fnt
	:== (	!{#Char}
		,	!Int
		,	!Int
		)
::	RGBcolor
	:==	(	!Int
		,	!Int
		,	!Int
		)
::	Pt
	:== (	!Int
		,	!Int
		)
::	*PIC
	:== (	!HDC
		,	!*OSToolbox
		)
::	CrossCallInfo
	=	{	ccMsg	:: !Int
		,	p1		:: !Int
		,	p2		:: !Int
		,	p3		:: !Int
		,	p4		:: !Int
		,	p5		:: !Int
		,	p6		:: !Int
		}

MaxRand				:== 32767

iWhitePattern		:== 4
iLtGreyPattern		:== 3
iGreyPattern		:== 2
iDkGreyPattern		:== 1
iBlackPattern		:== 0

iModeNotBic			:== 7
iModeNotXor			:== 6
iModeNotOr			:== 5
iModeNotCopy		:== 4
iModeBic			:== 3
iModeXor			:== 2
iModeOr				:== 1
iModeCopy			:== 0

iStrikeOut			:== 8
iUnderline			:== 4
iItalic				:== 2
iBold				:== 1

WinHelpKey			:== 5
WinEscapeKey		:== 27
WinEnterKey			:== 3
WinReturnKey		:== 13
WinTabKey			:== 9
WinDelKey			:== 127
WinBackSpKey		:== 8
WinEndKey			:== 4
WinBeginKey			:== 1
WinPgDownKey		:== 12
WinPgUpKey			:== 11
WinRightKey			:== 29
WinLeftKey			:== 28
WinDownKey			:== 31
WinUpKey			:== 30
WinF1Key			:==	1001
WinF2Key			:==	1002
WinF3Key			:==	1003
WinF4Key			:==	1004
WinF5Key			:==	1005
WinF6Key			:==	1006
WinF7Key			:==	1007
WinF8Key			:==	1008
WinF9Key			:==	1009
WinF10Key			:==	1010
WinF11Key			:==	1011
WinF12Key			:==	1012

CTRLBIT				:== 4
ALTBIT				:== 2
SHIFTBIT			:== 1

KEYREPEAT			:== 4
KEYUP				:== 2
KEYDOWN				:== 1

BUTTONUP			:== 50
BUTTONSTILLDOWN		:== 40
BUTTONTRIPLEDOWN	:== 3
BUTTONDOUBLEDOWN	:== 2
BUTTONDOWN			:== 1
BUTTONSTILLUP		:== 0		/* PA: new constant for passing mouse move events. */

CURSHIDDEN			:== 6
CURSARROW			:== 5
CURSFATCROSS		:== 4
CURSCROSS			:== 3
CURSIBEAM			:== 2
CURSBUSY			:== 1

//	PA: constants for handling scrollbars.
SB_HORZ				:== 0
SB_VERT				:== 1
SB_CTL				:== 2
SB_BOTH				:== 3

SB_LINEUP			:== 0
SB_LINELEFT			:== 0
SB_LINEDOWN			:== 1
SB_LINERIGHT		:== 1
SB_PAGEUP			:== 2
SB_PAGELEFT			:== 2
SB_PAGEDOWN			:== 3
SB_PAGERIGHT		:== 3
SB_THUMBPOSITION	:== 4
SB_THUMBTRACK		:== 5
SB_TOP				:== 6
SB_LEFT				:== 6
SB_BOTTOM			:== 7
SB_RIGHT			:== 7
SB_ENDSCROLL		:== 8
//	PA: end of addition.

//	PA: constants for handling window styles.
WS_OVERLAPPED		:== 0x00000000
WS_POPUP			:== 0x80000000
WS_CHILD			:== 0x40000000
WS_MINIMIZE			:== 0x20000000
WS_VISIBLE			:== 0x10000000
WS_DISABLED			:== 0x08000000
WS_CLIPSIBLINGS		:== 0x04000000
WS_CLIPCHILDREN		:== 0x02000000
WS_MAXIMIZE			:== 0x01000000
WS_CAPTION			:== 0x00C00000		/* WS_BORDER | WS_DLGFRAME  */
WS_BORDER			:== 0x00800000
WS_DLGFRAME			:== 0x00400000
WS_VSCROLL			:== 0x00200000
WS_HSCROLL			:== 0x00100000
WS_SYSMENU			:== 0x00080000
WS_THICKFRAME		:== 0x00040000
WS_GROUP			:== 0x00020000
WS_TABSTOP			:== 0x00010000

WS_MINIMIZEBOX		:== 0x00020000
WS_MAXIMIZEBOX		:== 0x00010000

WS_TILED			:== WS_OVERLAPPED
WS_ICONIC			:== WS_MINIMIZE
WS_SIZEBOX			:== WS_THICKFRAME
//	PA: end of addition.

//	PA: constants for stacking windows.
HWND_TOP			:==	0
HWND_BOTTOM			:==	1
HWND_TOPMOST		:== -1
HWND_NOTOPMOST		:==	-2
//	PA: end of addition.

//	PA: constants for drawing polygons.
ALTERNATE			:== 1
WINDING				:== 2
//	PA: end of addition.

//	PA: CombineRgn() Styles.
RGN_AND				:== 1
RGN_OR				:== 2
RGN_XOR				:== 3
RGN_DIFF			:== 4
RGN_COPY			:== 5
//	PA: end of addition.

//	PA: Predefined Clipboard Formats.
CF_TEXT             :==	1
CF_BITMAP           :==	2
CF_METAFILEPICT     :==	3
CF_SYLK             :==	4
CF_DIF              :==	5
CF_TIFF             :==	6
CF_OEMTEXT          :==	7
CF_DIB              :==	8
CF_PALETTE          :==	9
CF_PENDATA          :==	10
CF_RIFF             :==	11
CF_WAVE             :==	12
CF_UNICODETEXT      :==	13
CF_ENHMETAFILE      :==	14
//	PA: end of addition.

//	PA: flag values for passing information about edit controls from Clean to OS.
EDITISMULTILINE		:==	1			/* PA: flag value: edit control is multi-line. */
EDITISKEYSENSITIVE	:==	2			/* PA: flag value: edit control sends keyboard events to Clean. */
//	PA: end of addition.

//	Constants for passing messages from Clean to OS.
CcRqIDLETIMER			:== 1820

CcRqCLIPBOARDHASTEXT	:== 1812
CcRqGETCLIPBOARDTEXT	:== 1811
CcRqSETCLIPBOARDTEXT	:== 1810

CcRqFILESAVEDIALOG		:== 1801
CcRqFILEOPENDIALOG		:== 1800

CcRqSHOWCONTROL			:== 1755		/* PA: added */
CcRqSELECTPOPUPITEM		:== 1754
CcRqENABLEPOPUPITEM		:== 1753
CcRqADDTOPOPUP			:== 1752
CcRqSETITEMCHECK		:== 1751
CcRqENABLECONTROL		:== 1750

CcRqCREATECOMPOUND		:== 1729		/* PA: added */
CcRqCREATESCROLLBAR		:== 1728		/* PA: added */
CcRqCREATECUSTOM		:== 1727
CcRqCREATEICONBUT		:== 1726
CcRqCREATEPOPUP			:== 1725
CcRqCREATECHECKBOX		:== 1724
CcRqCREATERADIOBUT		:== 1723
CcRqCREATEEDITTXT		:== 1722
CcRqCREATESTATICTXT		:== 1721
CcRqCREATEBUTTON		:== 1720

CcRqGETACTIVEDIALOG		:== 1712
CcRqENDMODALDLOG		:== 1711
CcRqMODALDIALOG			:== 1710

CcRqCREATEDIALOG		:== 1700

CcRqGETBLINKTIME		:== 1670

CcRqWAIT				:== 1660

CcRqGETCURDATE			:== 1651
CcRqGETCURTIME			:== 1650

CcRqKILLTIMER			:== 1601
CcRqCREATETIMER			:== 1600

CcCbFONTSIZE			:== 1530

CcCbFONTNAME			:== 1520

CcRqGETFONTSIZES		:== 1510

CcRqGETFONTNAMES		:== 1500

CcRqRESTACKWINDOW		:==	1434		/* PA: added to restack windows. */
CcRqSHOWWINDOW			:==	1433		/* PA: added to (hide/show) windows. */
CcRqSETWINDOWSIZE		:==	1432		/* PA: added to resize windows/controls. */
CcRqSETSELECTWINDOW		:== 1431		/* PA: added to (en/dis)able windows. */
CcRqSETWINDOWPOS		:== 1430		/* PA: added to move windows/controls. */
CcRqINVALIDATERECT		:== 1429		/* PA: added for invalidating parts of a window/control. */
CcRqSETEDITSELECTION	:== 1428		/* PA: added for handling edit control selections. */
CcRqSETSCROLLSIZE		:==	1427		/* PA: added for setting thumb size of scrollbar. */
CcRqSETSCROLLPOS		:== 1426		/* PA: added for setting thumb of scrollbar. */
CcRqSETSCROLLRANGE		:== 1425		/* PA: added for setting range of scrollbar. */
CcRqRESETCURSOR			:== 1424
CcRqSETGLOBALCURSOR		:== 1423
CcRqOBSCURECURSOR		:== 1422
CcRqCHANGEWINDOWCURSOR	:== 1421
CcRqFIXEDTOSCROLL		:== 1420
CcRqRESIZEFIXED			:== 1419
CcRqRESIZESCROLL		:== 1418
CcRqGETSCROLLFRAME		:== 1417
CcRqGETWINDOWPOS		:== 1416
CcRqGETCLIENTSIZE		:== 1415
CcRqSCROLLWINDOW		:== 1414
CcRqSETVSCROLLINFO		:== 1413
CcRqSETHSCROLLINFO		:== 1412
CcRqGETWINDOWTEXT		:== 1411
CcRqSETWINDOWTITLE		:== 1410
CcRqSETFOREGROUNDWINDOW	:== 1409
CcRqGETFOREGROUNDWINDOW	:== 1408
CcRqINVALIDATEWINDOW	:== 1407
CcRqRELEASEDC			:== 1406
CcRqGETDC				:== 1405
CcRqENDPAINT			:== 1404
CcRqBEGINPAINT			:== 1403
CcRqDESTROYWINDOW		:== 1402
CcRqCREATESCROLLWINDOW	:== 1401
CcRqCREATEFIXEDWINDOW	:== 1400

CcRqMSGBOX				:== 1300

CcRqDRAWMBAR			:== 1265

CcRqCREATEMENUWINDOW	:== 1260

CcRqCREATEPOPMENU		:== 1255

CcRqCREATEMBAR			:== 1250

CcRqINSERTSEPARATOR		:== 1245

CcRqAPPENDSEPARATOR		:== 1240

CcRqMENUENABLE			:== 1235

CcRqMODIFYMENU			:== 1230

CcRqINSERTMENU			:==	1226		// PA: new constant for inserting a new menu into the menu bar
CcRqAPPENDMENU			:== 1225

CcRqITEMENABLE			:== 1220

CcRqMODIFYMENUITEM		:== 1215
CcRqDESTROYMENU			:== 1214		// PA: new constant for destroying a menu 'physically'
CcRqDELETEMENU			:==	1213		// PA: new constant for deleting a menu logically
CcRqREMOVEMENUITEM		:== 1212

CcRqCHECKMENUITEM		:== 1210

CcRqINSERTMENUITEM		:== 1205

CcRqAPPENDMENUITEM		:== 1200

CcRqDOMESSAGE			:== 1100

CcRqBEEP				:== 1001
CcRqCREATEWINDOW		:== 1000


//	Constants for passing messages from OS to Clean.
CcWINMESSmax			:== 999

CcWmDRAWCLIPBOARD		:==	126		/* PA: new constant for clipboard handling. Copied from Ronny. */
CcWmGETSCROLLBARINFO	:==	125		/* PA: new constant for info about scrollbars. */
CcWmSCROLLBARACTION		:== 124		/* PA: new constant for scrollbar handling. */
CcWmDDEEXECUTE			:== 123
CcWmLOSEMODELESSDLOG	:== 122
CcWmSETCURSOR			:== 121
CcWmDRAWCONTROL			:== 120
CcWmCOMBOSELECT			:== 119
CcWmBUTTONCLICKED		:== 118
CcWmINITDIALOG			:== 117
CcWmIDLETIMER			:== 116
CcWmTIMER				:== 115
CcWmNEWVTHUMB			:== 114
CcWmNEWHTHUMB			:== 113
CcWmGETVSCROLLVAL		:== 112
CcWmGETHSCROLLVAL		:== 111
CcWmSIZE				:== 110		/* PA: old constant reused for passing resize information. */
CcWmMOUSE				:== 109
CcWmKEYBOARD			:== 108
CcWmDEACTIVATE			:== 107
CcWmACTIVATE			:== 106
CcWmCLOSE				:== 105
CcWmGETMINMAXINFO		:== 104
CcWmCOMMAND				:== 103
CcWmCHAR				:== 102
CcWmCREATE				:== 101
CcWmPAINT				:== 100

CcWINMESSmin			:== 100

CcWmNOTIFY				:== 78

CcRETURNmax				:== 19

CcRETURN6				:== 16
CcRETURN5				:== 15
CcRETURN4				:== 14
CcRETURN3				:== 13
CcRETURN2				:== 12
CcRETURN1				:== 11
CcRETURN0				:== 10

CcRETURNmin				:== 10

CcWASQUIT				:== 1


WinLaunchApp ::  !{#Char} !Bool !*OSToolbox -> ( !Bool, !*OSToolbox)
WinLaunchApp _ _ _
	= code
	{
		.inline WinLaunchApp
			ccall WinLaunchApp "SII-II"
		.end
	}

WinCallProcess ::  !CSTR !CSTR !CSTR !CSTR !CSTR !CSTR !*OSToolbox -> ( !Bool, !Int, !*OSToolbox)
WinCallProcess _ _ _ _ _ _ _
	= code
	{
		.inline WinCallProcess
			ccall WinCallProcess "IIIIIII-III"
		.end
	}

WinGetModulePath ::  {#Char}
WinGetModulePath
	= code
	{
		.inline WinGetModulePath
			ccall WinGetModulePath "-S"
		.end
	}

WinFileModifiedDate ::  !{#Char} -> ( !Bool, !Int, !Int, !Int, !Int, !Int, !Int)
WinFileModifiedDate _
	= code
	{
		.inline WinFileModifiedDate
			ccall WinFileModifiedDate "S-IIIIIII"
		.end
	}

WinFileExists ::  !{#Char} ->  Bool
WinFileExists _
	= code
	{
		.inline WinFileExists
			ccall WinFileExists "S-I"
		.end
	}

Rand ::  Int
Rand
	= code
	{
		.inline Rand
			ccall Rand "-I"
		.end
	}

ConsolePrint ::  !{#Char} !*OSToolbox ->  *OSToolbox
ConsolePrint _ _
	= code
	{
		.inline ConsolePrint
			ccall ConsolePrint "SI-I"
		.end
	}

WinReleaseCString ::  !CSTR !*OSToolbox ->  *OSToolbox
WinReleaseCString _ _
	= code
	{
		.inline WinReleaseCString
			ccall WinReleaseCString "II-I"
		.end
	}

WinGetCStringAndFree ::  !CSTR !*OSToolbox -> ( !{#Char}, !*OSToolbox)
WinGetCStringAndFree _ _
	= code
	{
		.inline WinGetCStringAndFree
			ccall WinGetCStringAndFree "II-SI"
		.end
	}

WinGetCString ::  !CSTR !*OSToolbox -> ( !{#Char}, !*OSToolbox)
WinGetCString _ _
	= code
	{
		.inline WinGetCString
			ccall WinGetCString "II-SI"
		.end
	}

WinMakeCString ::  !{#Char} !*OSToolbox -> ( !CSTR, !*OSToolbox)
WinMakeCString _ _
	= code
	{
		.inline WinMakeCString
			ccall WinMakeCString "SI-II"
		.end
	}

WinGetAppPath ::  CSTR
WinGetAppPath
	= code
	{
		.inline WinGetAppPath
			ccall WinGetAppPath "-I"
		.end
	}

WinSetDoubleDownDist ::  !Int !*OSToolbox ->  *OSToolbox
WinSetDoubleDownDist _ _
	= code
	{
		.inline WinSetDoubleDownDist
			ccall WinSetDoubleDownDist "II-I"
		.end
	}

WinKickOsThread ::  !CrossCallInfo !*OSToolbox -> ( !CrossCallInfo, !*OSToolbox)
WinKickOsThread _ _
	= code
	{
		.inline WinKickOsThread
			ccall WinKickOsThread "IIIIIIII-IIIIIIII"
		.end
	}

WinKillOsThread ::  !*OSToolbox ->  *OSToolbox
WinKillOsThread _
	= code
	{
		.inline WinKillOsThread
			ccall WinKillOsThread "I-I"
		.end
	}

WinStartOsThread ::  !*OSToolbox ->  *OSToolbox
WinStartOsThread _
	= code
	{
		.inline WinStartOsThread
			ccall WinStartOsThread "I-I"
		.end
	}

WinCloseOs ::  !*OSToolbox ->  Bool
WinCloseOs _
	= code
	{
		.inline WinCloseOs
			ccall WinCloseOs "I-I"
		.end
	}

WinInitOs :: ( !Bool, !*OSToolbox)
WinInitOs
	= code
	{
		.inline WinInitOs
			ccall WinInitOs "-II"
		.end
	}

WinGetHorzResolution ::  Int
WinGetHorzResolution
	= code
	{
		.inline WinGetHorzResolution
			ccall WinGetHorzResolution "-I"
		.end
	}

WinGetVertResolution ::  Int
WinGetVertResolution
	= code
	{
		.inline WinGetVertResolution
			ccall WinGetVertResolution "-I"
		.end
	}

WinMaxFixedWindowSize :: ( !Int, !Int)
WinMaxFixedWindowSize
	= code
	{
		.inline WinMaxFixedWindowSize
			ccall WinMaxFixedWindowSize "-II"
		.end
	}

WinMaxScrollWindowSize :: ( !Int, !Int)
WinMaxScrollWindowSize
	= code
	{
		.inline WinMaxScrollWindowSize
			ccall WinMaxScrollWindowSize "-II"
		.end
	}

//	PA: interface added for determining screen width and height.
WinScreenYSize :: !*OSToolbox -> (!Int,!*OSToolbox)
WinScreenYSize _
	= code
	{	
		.inline WinScreenYSize
			ccall WinScreenYSize "I-II"
		.end
	}

WinScreenXSize :: !*OSToolbox -> (!Int,!*OSToolbox)
WinScreenXSize _
	= code
	{	
		.inline WinScreenXSize
			ccall WinScreenXSize "I-II"
		.end
	}

WinMinimumWinSize :: ( !Int, !Int)
WinMinimumWinSize
	= code
	{
		.inline WinMinimumWinSize
			ccall WinMinimumWinSize "-II"
		.end
	}

//	PA: function added to get system metrics for width and height of scrollbars.
WinScrollbarSize :: !*OSToolbox -> ( !Int, !Int, !*OSToolbox )
WinScrollbarSize _
	= code
	{	
		.inline WinScrollbarSize
			ccall WinScrollbarSize "I-III"
		.end
	}

WinActivateShortcutTable ::  !ACCLPTR !Int !*OSToolbox ->  *OSToolbox
WinActivateShortcutTable _ _ _
	= code
	{
		.inline WinActivateShortcutTable
			ccall WinActivateShortcutTable "III-I"
		.end
	}

WinCopyShortcutToTable ::  !Char !Int !Int !ACCLPTR !*OSToolbox ->  *OSToolbox
WinCopyShortcutToTable _ _ _ _ _
	= code
	{
		.inline WinCopyShortcutToTable
			ccall WinCopyShortcutToTable "IIIII-I"
		.end
	}

WinAllocShortcutTable ::  !Int !*OSToolbox -> ( !ACCLPTR, !*OSToolbox)
WinAllocShortcutTable _ _
	= code
	{
		.inline WinAllocShortcutTable
			ccall WinAllocShortcutTable "II-II"
		.end
	}

// RWS ...
WinSetShortcut ::  !Int !Char !*OSToolbox ->  *OSToolbox
WinSetShortcut _ _ _
	= code
	{
		.inline WinSetShortcut
			ccall WinSetShortcut "III-I"
		.end
	}

/*	PA: implemented as crosscall.
WinDestroyMenu ::  !Int !*OSToolbox ->  *OSToolbox
WinDestroyMenu _ _
	= code
	{
		.inline WinDestroyMenu
			ccall WinDestroyMenu "I-I"
		.end
	}
... PA */
// ... RWS

// MW: this is never used in the object IO
WinGetPicStringWidth ::  !{#Char} !PIC -> ( !Int, !PIC)
WinGetPicStringWidth _ _
	= code
	{
		.inline WinGetPicStringWidth
			ccall WinGetPicStringWidth "SII-III"
		.end
	}

WinGetPicCharWidth ::  !Char !PIC -> ( !Int, !PIC)
WinGetPicCharWidth _ _
	= code
	{
		.inline WinGetPicCharWidth
			ccall WinGetPicCharWidth "III-III"
		.end
	}
// END MW

WinGetStringWidth ::  !{#Char} !Fnt !Int !HDC !*OSToolbox -> ( !Int, !*OSToolbox)
WinGetStringWidth _ _ _ _ _
	= code
	{
		.inline WinGetStringWidth
			ccall WinGetStringWidth "SSIIIII-II"
		.end
	}

WinGetCharWidth ::  !Char !Fnt !Int !HDC !*OSToolbox -> ( !Int, !*OSToolbox)
WinGetCharWidth _ _ _ _ _
	= code
	{
		.inline WinGetCharWidth
			ccall WinGetCharWidth "ISIIIII-II"
		.end
	}

WinGetPicFontInfo ::  !PIC -> ( !Int, !Int, !Int, !Int, !PIC)
WinGetPicFontInfo _
	= code
	{
		.inline WinGetPicFontInfo
			ccall WinGetPicFontInfo "II-IIIIII"
		.end
	}

WinGetFontInfo ::  !Fnt !Int !HDC !*OSToolbox -> ( !Int, !Int, !Int, !Int, !*OSToolbox)
WinGetFontInfo _ _ _ _
	= code
	{
		.inline WinGetFontInfo
			ccall WinGetFontInfo "SIIIII-IIIII"
		.end
	}

WinSetFontStyle ::  !Int !PIC ->  PIC
WinSetFontStyle _ _
	= code
	{
		.inline WinSetFontStyle
			ccall WinSetFontStyle "III-II"
		.end
	}

WinSetFontSize ::  !Int !PIC ->  PIC
WinSetFontSize _ _
	= code
	{
		.inline WinSetFontSize
			ccall WinSetFontSize "III-II"
		.end
	}

WinSetFontName ::  !{#Char} !PIC ->  PIC
WinSetFontName _ _
	= code
	{
		.inline WinSetFontName
			ccall WinSetFontName "SII-II"
		.end
	}

WinSetFont ::  !Fnt !PIC ->  PIC
WinSetFont _ _
	= code
	{
		.inline WinSetFont
			ccall WinSetFont "SIIII-II"
		.end
	}

//	PA: new routine to draw bitmaps.
WinDrawBitmap :: !(!Int,!Int) !(!Int,!Int,!Int,!Int) !{#Char} !PIC -> PIC
WinDrawBitmap _ _ _ _
	= code
	{
		.inline WinDrawBitmap
			ccall WinDrawBitmap "IIIIIISII-II"
		.end
	}

WinInvertPolygon ::  !PIC ->  PIC
WinInvertPolygon _
	= code
	{
		.inline WinInvertPolygon
			ccall WinInvertPolygon "II-II"
		.end
	}

WinErasePolygon ::  !PIC ->  PIC
WinErasePolygon _
	= code
	{
		.inline WinErasePolygon
			ccall WinErasePolygon "II-II"
		.end
	}

WinFillPolygon ::  !PIC ->  PIC
WinFillPolygon _
	= code
	{
		.inline WinFillPolygon
			ccall WinFillPolygon "II-II"
		.end
	}

WinDrawPolygon ::  !PIC ->  PIC
WinDrawPolygon _
	= code
	{
		.inline WinDrawPolygon
			ccall WinDrawPolygon "II-II"
		.end
	}

WinAddPolygonPoint ::  !Pt !*OSToolbox ->  *OSToolbox
WinAddPolygonPoint _ _
	= code
	{
		.inline WinAddPolygonPoint
			ccall WinAddPolygonPoint "III-I"
		.end
	}

WinStartPolygon ::  !Int !*OSToolbox ->  *OSToolbox
WinStartPolygon _ _
	= code
	{
		.inline WinStartPolygon
			ccall WinStartPolygon "II-I"
		.end
	}

WinEndPolygon :: !*OSToolbox -> *OSToolbox
WinEndPolygon _
	= code
	{	
		.inline WinEndPolygon
			ccall WinEndPolygon "I-I"
		.end
	}

WinInvertWedge ::  !Rect !Pt !Pt !PIC ->  PIC
WinInvertWedge _ _ _ _
	= code
	{
		.inline WinInvertWedge
			ccall WinInvertWedge "IIIIIIIIII-II"
		.end
	}

WinEraseWedge ::  !Rect !Pt !Pt !PIC ->  PIC
WinEraseWedge _ _ _ _
	= code
	{
		.inline WinEraseWedge
			ccall WinEraseWedge "IIIIIIIIII-II"
		.end
	}

WinFillWedge ::  !Rect !Pt !Pt !PIC ->  PIC
WinFillWedge _ _ _ _
	= code
	{
		.inline WinFillWedge
			ccall WinFillWedge "IIIIIIIIII-II"
		.end
	}

WinDrawWedge ::  !Rect !Pt !Pt !PIC ->  PIC
WinDrawWedge _ _ _ _
	= code
	{
		.inline WinDrawWedge
			ccall WinDrawWedge "IIIIIIIIII-II"
		.end
	}

WinInvertCircle ::  !Pt !Int !PIC ->  PIC
WinInvertCircle _ _ _
	= code
	{
		.inline WinInvertCircle
			ccall WinInvertCircle "IIIII-II"
		.end
	}

WinEraseCircle ::  !Pt !Int !PIC ->  PIC
WinEraseCircle _ _ _
	= code
	{
		.inline WinEraseCircle
			ccall WinEraseCircle "IIIII-II"
		.end
	}

WinFillCircle ::  !Pt !Int !PIC ->  PIC
WinFillCircle _ _ _
	= code
	{
		.inline WinFillCircle
			ccall WinFillCircle "IIIII-II"
		.end
	}

WinDrawCircle ::  !Pt !Int !PIC ->  PIC
WinDrawCircle _ _ _
	= code
	{
		.inline WinDrawCircle
			ccall WinDrawCircle "IIIII-II"
		.end
	}

WinInvertOval ::  !Rect !PIC ->  PIC
WinInvertOval _ _
	= code
	{
		.inline WinInvertOval
			ccall WinInvertOval "IIIIII-II"
		.end
	}

WinEraseOval ::  !Rect !PIC ->  PIC
WinEraseOval _ _
	= code
	{
		.inline WinEraseOval
			ccall WinEraseOval "IIIIII-II"
		.end
	}

WinFillOval ::  !Rect !PIC ->  PIC
WinFillOval _ _
	= code
	{
		.inline WinFillOval
			ccall WinFillOval "IIIIII-II"
		.end
	}

WinDrawOval ::  !Rect !PIC ->  PIC
WinDrawOval _ _
	= code
	{
		.inline WinDrawOval
			ccall WinDrawOval "IIIIII-II"
		.end
	}

WinInvertRoundRectangle ::  !Rect !Int !Int !PIC ->  PIC
WinInvertRoundRectangle _ _ _ _
	= code
	{
		.inline WinInvertRoundRectangle
			ccall WinInvertRoundRectangle "IIIIIIII-II"
		.end
	}

WinEraseRoundRectangle ::  !Rect !Int !Int !PIC ->  PIC
WinEraseRoundRectangle _ _ _ _
	= code
	{
		.inline WinEraseRoundRectangle
			ccall WinEraseRoundRectangle "IIIIIIII-II"
		.end
	}

WinFillRoundRectangle ::  !Rect !Int !Int !PIC ->  PIC
WinFillRoundRectangle _ _ _ _
	= code
	{
		.inline WinFillRoundRectangle
			ccall WinFillRoundRectangle "IIIIIIII-II"
		.end
	}

WinDrawRoundRectangle ::  !Rect !Int !Int !PIC ->  PIC
WinDrawRoundRectangle _ _ _ _
	= code
	{
		.inline WinDrawRoundRectangle
			ccall WinDrawRoundRectangle "IIIIIIII-II"
		.end
	}

WinCopyRectangle ::  !Rect !Pt !PIC ->  PIC
WinCopyRectangle _ _ _
	= code
	{
		.inline WinCopyRectangle
			ccall WinCopyRectangle "IIIIIIII-II"
		.end
	}

WinCopyRectangleTo ::  !Rect !Pt !PIC ->  PIC
WinCopyRectangleTo _ _ _
	= code
	{
		.inline WinCopyRectangleTo
			ccall WinCopyRectangleTo "IIIIIIII-II"
		.end
	}

WinMoveRectangle ::  !Rect !Pt !PIC ->  PIC
WinMoveRectangle _ _ _
	= code
	{
		.inline WinMoveRectangle
			ccall WinMoveRectangle "IIIIIIII-II"
		.end
	}

WinMoveRectangleTo ::  !Rect !Pt !PIC ->  PIC
WinMoveRectangleTo _ _ _
	= code
	{
		.inline WinMoveRectangleTo
			ccall WinMoveRectangleTo "IIIIIIII-II"
		.end
	}

WinInvertRectangle ::  !Rect !PIC ->  PIC
WinInvertRectangle _ _
	= code
	{
		.inline WinInvertRectangle
			ccall WinInvertRectangle "IIIIII-II"
		.end
	}

WinEraseRectangle ::  !Rect !PIC ->  PIC
WinEraseRectangle _ _
	= code
	{
		.inline WinEraseRectangle
			ccall WinEraseRectangle "IIIIII-II"
		.end
	}

WinFillRectangle ::  !Rect !PIC ->  PIC
WinFillRectangle _ _
	= code
	{
		.inline WinFillRectangle
			ccall WinFillRectangle "IIIIII-II"
		.end
	}

WinDrawRectangle ::  !Rect !PIC ->  PIC
WinDrawRectangle _ _
	= code
	{
		.inline WinDrawRectangle
			ccall WinDrawRectangle "IIIIII-II"
		.end
	}

WinDrawChar ::  !Int !PIC ->  PIC
WinDrawChar _ _
	= code
	{
		.inline WinDrawChar
			ccall WinDrawChar "III-II"
		.end
	}

WinDrawString ::  !{#Char} !PIC ->  PIC
WinDrawString _ _
	= code
	{
		.inline WinDrawString
			ccall WinDrawString "SII-II"
		.end
	}

WinDrawCCurve ::  !Rect !Pt !Pt !RGBcolor !PIC ->  PIC
WinDrawCCurve _ _ _ _ _
	= code
	{
		.inline WinDrawCCurve
			ccall WinDrawCCurve "IIIIIIIIIIIII-II"
		.end
	}

WinDrawCLine ::  !Pt !Pt !RGBcolor !PIC ->  PIC
WinDrawCLine _ _ _ _
	= code
	{
		.inline WinDrawCLine
			ccall WinDrawCLine "IIIIIIIII-II"
		.end
	}

WinDrawCPoint ::  !Pt !RGBcolor !PIC ->  PIC
WinDrawCPoint _ _ _
	= code
	{
		.inline WinDrawCPoint
			ccall WinDrawCPoint "IIIIIII-II"
		.end
	}

WinDrawCurve ::  !Rect !Pt !Pt !PIC ->  PIC
WinDrawCurve _ _ _ _
	= code
	{
		.inline WinDrawCurve
			ccall WinDrawCurve "IIIIIIIIII-II"
		.end
	}

WinDrawLine ::  !Pt !Pt !PIC ->  PIC
WinDrawLine _ _ _
	= code
	{
		.inline WinDrawLine
			ccall WinDrawLine "IIIIII-II"
		.end
	}

WinDrawPoint ::  !Pt !PIC ->  PIC
WinDrawPoint _ _
	= code
	{
		.inline WinDrawPoint
			ccall WinDrawPoint "IIII-II"
		.end
	}

WinLinePen ::  !Pt !PIC ->  PIC
WinLinePen _ _
	= code
	{
		.inline WinLinePen
			ccall WinLinePen "IIII-II"
		.end
	}

WinLinePenTo ::  !Pt !PIC ->  PIC
WinLinePenTo _ _
	= code
	{
		.inline WinLinePenTo
			ccall WinLinePenTo "IIII-II"
		.end
	}

WinMovePen ::  !Pt !PIC ->  PIC
WinMovePen _ _
	= code
	{
		.inline WinMovePen
			ccall WinMovePen "IIII-II"
		.end
	}

WinMovePenTo ::  !Pt !PIC ->  PIC
WinMovePenTo _ _
	= code
	{
		.inline WinMovePenTo
			ccall WinMovePenTo "IIII-II"
		.end
	}

WinSetPattern ::  !Int !PIC ->  PIC
WinSetPattern _ _
	= code
	{
		.inline WinSetPattern
			ccall WinSetPattern "III-II"
		.end
	}

WinGetPenPos :: !PIC -> (!Pt, !PIC)
WinGetPenPos _
	= code
	{	
		.inline WinGetPenPos
			ccall WinGetPenPos "II-IIII"
		.end
	}

WinSetMode ::  !Int !PIC ->  PIC
WinSetMode _ _
	= code
	{
		.inline WinSetMode
			ccall WinSetMode "III-II"
		.end
	}

WinSetBackColor ::  !RGBcolor !PIC ->  PIC
WinSetBackColor _ _
	= code
	{
		.inline WinSetBackColor
			ccall WinSetBackColor "IIIII-II"
		.end
	}

WinSetPenColor ::  !RGBcolor !PIC ->  PIC
WinSetPenColor _ _
	= code
	{
		.inline WinSetPenColor
			ccall WinSetPenColor "IIIII-II"
		.end
	}

WinSetPenSize ::  !Int !PIC ->  PIC
WinSetPenSize _ _
	= code
	{
		.inline WinSetPenSize
			ccall WinSetPenSize "III-II"
		.end
	}

WinClipPicture ::  !Rect !PIC ->  PIC
WinClipPicture _ _
	= code
	{
		.inline WinClipPicture
			ccall WinClipPicture "IIIIII-II"
		.end
	}

//	PA: operation to set the clipping region.
WinClipRgnPicture :: !HRGN !PIC -> (!HRGN,!PIC)
WinClipRgnPicture _ _
	= code
	{	
		.inline WinClipRgnPicture
			ccall WinClipRgnPicture "III-III"
		.end
	}

/*	PA: operations to create, modify, and destroy polygon shapes.
*/
WinAllocPolyShape :: !Int !*OSToolbox -> (!Int,!*OSToolbox)
WinAllocPolyShape _ _
	= code
	{	
		.inline WinAllocPolyShape
			ccall WinAllocPolyShape "II-II"
		.end
	}

WinSetPolyPoint :: !Int !Int !Int !Int !*OSToolbox -> *OSToolbox
WinSetPolyPoint _ _ _ _ _
	= code
	{	
		.inline WinSetPolyPoint
			ccall WinSetPolyPoint "IIIII-I"
		.end
	}

WinFreePolyShape :: !Int !*OSToolbox -> *OSToolbox
WinFreePolyShape _ _
	= code
	{	
		.inline WinFreePolyShape
			ccall WinFreePolyShape "II-I"
		.end
	}
/*	PA: end of addition.
*/

/*	PA: operations to create, modify and destroy regions.
*/
WinCreateRectRgn :: !Int !Int !Int !Int !*OSToolbox -> (!HRGN,!*OSToolbox)
WinCreateRectRgn _ _ _ _ _
	= code
	{	
		.inline WinCreateRectRgn
			ccall WinCreateRectRgn "IIIII-II"
		.end
	}

WinCreatePolygonRgn :: !Int !Int !Int !*OSToolbox -> (!HRGN,!*OSToolbox)
WinCreatePolygonRgn _ _ _ _
	= code
	{	
		.inline WinCreatePolygonRgn
			ccall WinCreatePolygonRgn "IIII-II"
		.end
	}

WinSetRgnToRect :: !Int !Int !Int !Int !HRGN !*OSToolbox -> (!HRGN,!*OSToolbox)
WinSetRgnToRect _ _ _ _ _ _
	= code
	{	
		.inline WinSetRgnToRect
			ccall WinSetRgnToRect "IIIIII-II"
		.end
	}

WinCombineRgn :: !HRGN !HRGN !HRGN !Int !*OSToolbox -> (!HRGN,!*OSToolbox)
WinCombineRgn _ _ _ _ _
	= code
	{	
		.inline WinCombineRgn
			ccall WinCombineRgn "IIIII-II"
		.end
	}

WinGetRgnBox :: !HRGN !*OSToolbox -> (!Int,!Int,!Int,!Int,!Bool,!*OSToolbox)
WinGetRgnBox _ _
	= code
	{	
		.inline WinGetRgnBox
			ccall WinGetRgnBox "II-IIIIII"
		.end
	}

WinDeleteObject :: !Int !*OSToolbox -> *OSToolbox
WinDeleteObject _ _
	= code
	{	
		.inline WinDeleteObject
			ccall WinDeleteObject "II-I"
		.end
	}
/*	PA: end of addition.
*/

WinDonePicture ::  !PIC -> ( !Int, !Int, !RGBcolor, !RGBcolor, !Pt, !Fnt, !PIC)
WinDonePicture _
	= code
	{
		.inline WinDonePicture
			ccall WinDonePicture "II-IIIIIIIIIISIIII"
		.end
	}

WinInitPicture ::  !Int !Int !RGBcolor !RGBcolor !Pt !Fnt !Pt !PIC ->  PIC
WinInitPicture _ _ _ _ _ _ _ _
	= code
	{
		.inline WinInitPicture
			ccall WinInitPicture "IIIIIIIIIISIIIIII-II"
		.end
	}

WinGetTickCount ::  !*OSToolbox -> (!Int, !*OSToolbox)
WinGetTickCount _
	= code
	{
		.inline WinGetTickCount
			ccall WinGetTickCount "I-II"
		.end
	}
